/*
  EK_ADS7828 - ADS7828 I2C ADC library
  Derived from "Adafruit_ADS7830" by Adafruit Industries

  Original work Copyright (c) Adafruit Industries
  Modified work Copyright (c) 2026 Electrokit Sweden AB

  This library is free software; you can redistribute it and/or modify it
  under the terms of the BSD license. Redistribution must retain the above
  copyright notices and this permission notice.
*/

#ifndef EK_ADS7828_H
#define EK_ADS7828_H

#include <Adafruit_I2CDevice.h>

#define EK_ADS7828_DEFAULT_ADDR  0x48
#define EK_ADS7828_DEFAULT_I2C_CLOCK 400000UL

typedef enum {
  POWER_DOWN_BETWEEN_CONVERSIONS = 0x00,
  INTERNAL_REF_OFF_ADC_ON        = 0x01,
  INTERNAL_REF_ON_ADC_OFF        = 0x02,
  INTERNAL_REF_ON_ADC_ON         = 0x03
} ek7828PowerDownSelection;

typedef enum {
  DIFF_CH0_CH1 = 0x00,
  DIFF_CH2_CH3 = 0x01,
  DIFF_CH4_CH5 = 0x02,
  DIFF_CH6_CH7 = 0x03,
  DIFF_CH1_CH0 = 0x04,
  DIFF_CH3_CH2 = 0x05,
  DIFF_CH5_CH4 = 0x06,
  DIFF_CH7_CH6 = 0x07,
  SINGLE_CH0   = 0x08,
  SINGLE_CH2   = 0x09,
  SINGLE_CH4   = 0x0A,
  SINGLE_CH6   = 0x0B,
  SINGLE_CH1   = 0x0C,
  SINGLE_CH3   = 0x0D,
  SINGLE_CH5   = 0x0E,
  SINGLE_CH7   = 0x0F
} ek7828ChannelSelectionControl;

class EK_ADS7828 {
public:
  EK_ADS7828();

  // Begin with defaults
  bool begin(TwoWire *theWire = &Wire);

  // Begin with explicit address
  bool begin(uint8_t i2c_addr, TwoWire *theWire = &Wire);

  // Optional configuration
  void setI2CClock(uint32_t hz);
  uint8_t getAddress() const;

  int16_t readADCsingle(uint8_t ch,
                        ek7828PowerDownSelection pd = INTERNAL_REF_ON_ADC_ON);

  int16_t readADCdifferential(uint8_t ch,
                              ek7828PowerDownSelection pd = INTERNAL_REF_ON_ADC_ON);

  int16_t readADCdifferential(ek7828ChannelSelectionControl sel,
                              ek7828PowerDownSelection pd = INTERNAL_REF_ON_ADC_ON);

private:
  uint8_t i2c_addr;
  uint32_t i2c_clock;
  TwoWire *wire;
  Adafruit_I2CDevice *i2c_dev;
};

#endif
