/*

What's a potentiometer?

  A potentiometer, or "pot" for short, is a control knob.
  It's the same type of control you'd use to change volume, 
  dim a lamp, etc. A potentiometer changes resistance as it
  is turned. By using it as a "voltage divider", the Arduino
  can sense the position of the knob, and use that value to
  control whatever you wish (like the blink rate of an LED,
  as we're doing here).
	
Hardware connections:

  Potentiometer:
	
    Potentiometers have three pins. When we're using it as a
    voltage divider, we connect the outside pins to power and
    ground. The middle pin will be the signal (a voltage which
    varies from 0 Volts to 5 Volts depending on the position of
    the knob).

    Connect the middle pin to ANALOG IN pin 0 on the Arduino.
    Connect one of the outside pins to 5V.
    Connect the other outside pin to GND.

    (TIP: if once your program is running, the knob feels
    "backwards", you can swap the 5V and GND pins to reverse
    the direction.)
		
  LED:

    Most Arduinos already have an LED and resistor connected to
    pin 13, so you may not need any additional circuitry.

    But if you'd like to connect a second LED to pin 13, or use
    a different pin, follow these steps:

      Connect the positive side of your LED (longer leg) to
      Arduino digital pin 13 (or another digital pin, but don't
      forget to change the code to match).
      
      Connect the negative side of your LED (shorter leg) to a
      330 Ohm resistor (orange-orange-brown).
      
      Connect the other side of the resistor to ground.
*/

// Welcome back! In this sketch we'll start using "variables".

// A variable is a named number. We'll often use these to store
// numbers that change, such as measurements from the outside
// world, or to make a sketch easier to understand (sometimes a
// descriptive name makes more sense than looking at a number).

// Variables can be different "data types", which is the kind of
// number we're using (can it be negative? Have a decimal point?)
// We'll introduce more data types later, but for the moment we'll
// stick with good old "integers" (called "int" in your sketch).

// Integers are whole numbers (0, 3, 5643), can be negative, and
// for reasons we won't go into right now, can range from -32768
// to 32767. (Don't worry, if you need to work with larger numbers,
// there are other data types for that. See:
// http://arduino.cc/en/Reference/VariableDeclaration
// for a list of all the data types you can use).

// You must "declare" variables before you use them, so that the
// computer knows about them. In this sketch, we declare two integer
// variables, and at the same time, initialize them to specific
// values. We're doing this so that further on in the code, we can refer to
// the pins by name rather than number.

// Note that variable names are case-sensitive! If you get an
// "(variable) was not declared in this scope" error, double-check
// that you typed the name correctly.

// First we create a variable called "sensorPin" of type "int"
// and initializing it to have the value "A0":

// One more thing. If you declare variables outside of a function,
// as we have here, they are called "global variables" and can be
// seen by all the functions. If you declare variables within a 
// function, they can only be seen within that function. It's good
// practice to "limit the scope" of a variable whenever possible,
// but as we're getting started, global variables are just fine.

// We'll be using pin 13 to light a LED, so we must configure it
// as an output.
 
// Because we already created a variable called ledPin, and
// set it equal to 13, we can use "ledPin" in place of "13".
// This makes the sketch easier to follow. That means that
// "pinMode(ledPin, OUTPUT)" is the same as "pinMode(13, OUTPUT);"

// You might be wondering why we're not also configuring
// sensorPin as an input. The reason is that this is an
// "analog in" pin. These pins have the special ability to
// read varying voltages from sensors like the potentiometer.
// Since they're always used as inputs, there is no need to
// specifically configure them.

// The potentiometer is set up as a voltage divider, so that
// when you turn it, the voltage on the center pin will vary
// from 0V to 5V. We've connected the center pin on the
// potentiometer to the Arduino's analog input 0.

// The Arduino can read external voltages on the analog input
// pins using a built-in function called analogRead(). This
// function takes one input value, the analog pin we're using
// (sensorPin, which we earlier set to 0). It returns an integer
// number that ranges from 0 (0 Volts) to 1023 (5 Volts).
// We're sticking this value into the sensorValue variable:
// Now we'll blink the LED like in the first example, but we'll
// use the sensorValue variable to change the blink speed
// (the smaller the number, the faster it will blink).

// Note that we're using the ledPin variable for blinking the LED.


